import boto3

from django.conf import settings


s3_session = boto3.session.Session(
    aws_access_key_id=settings.AWS_ACCESS_KEY_ID,
    aws_secret_access_key=settings.AWS_SECRET_ACCESS_KEY,
)


def s3_client():
    client = s3_session.client('s3', endpoint_url=settings.S3_HOST)
    return client


STORED_RESPONSES_BUCKET_NAME = 'staff.oebs.stored-responses'
