from datetime import datetime

from staff.celery_app import app
from staff.lib.db import atomic
from staff.lib.tasks import LockedTask
from staff.lib.utils.date import get_timedelta_setting
from staff.oebs.models import StoredResponse
from staff.oebs.stored_responses_storage import s3_client, STORED_RESPONSES_BUCKET_NAME


@app.task
class CleanStoredResponsesTask(LockedTask):
    def locked_run(self, *args, **kwargs):
        interval = get_timedelta_setting('OEBS_STORED_RESPONSE_CLEANUP_INTERVAL')
        lookup = {
            'created_at__lt': datetime.now() - interval,
            'is_auto_removable': True,
        }
        for stored_response in StoredResponse.objects.filter(**lookup):
            with atomic():
                s3_client().delete_object(Bucket=STORED_RESPONSES_BUCKET_NAME, Key=stored_response.s3_key)
                stored_response.delete()
