from datetime import date

from django.db.models import Q

from staff.celery_app import app
from staff.departments.models import Bonus
from staff.lib.tasks import LockedTask
from staff.lib.sync_tools.st_translation_sync import FieldSyncParams, StartrekFieldsSync
from staff.oebs.models import HRProduct, Occupation, Review, Reward


@app.task(ignore_result=True)
class SyncReviewFieldTask(LockedTask):
    def locked_run(self, *args, **kwargs):
        today = date.today()
        q = Q(start_date__lte=today) & (Q(end_date=None) | Q(end_date__gte=today))
        params = FieldSyncParams(
            qs=Review.objects.filter(q),
            key_field='scheme_id',
            key_prefix='oebs',
            translation_ru_field='name',
            translation_en_field='name',
            startrek_field='reviewScheme2'
        )

        sync = StartrekFieldsSync(params)
        sync.sync()


@app.task(ignore_result=True)
class SyncBonusFieldTask(LockedTask):
    def locked_run(self, *args, **kwargs):
        today = date.today()
        q = Q(start_date__lte=today) & (Q(end_date=None) | Q(end_date__gte=today))
        params = FieldSyncParams(
            qs=Bonus.objects.filter(intranet_status=1).filter(q),
            key_prefix='oebs',
            key_field='scheme_id',
            translation_ru_field='description',
            translation_en_field='description',
            startrek_field='bonusScheme2'
        )

        sync = StartrekFieldsSync(params)
        sync.sync()


@app.task(ignore_result=True)
class SyncRewardFieldTask(LockedTask):
    def locked_run(self, *args, **kwargs):
        today = date.today()
        q = Q(start_date__lte=today) & (Q(end_date=None) | Q(end_date__gte=today))
        params = FieldSyncParams(
            qs=Reward.objects.filter(q),
            key_prefix='oebs',
            key_field='scheme_id',
            translation_ru_field='name',
            translation_en_field='name',
            startrek_field='compensationScheme2'
        )

        sync = StartrekFieldsSync(params)
        sync.sync()


@app.task(ignore_result=True)
class SyncHRProductFieldTask(LockedTask):
    def locked_run(self, *args, **kwargs):
        today = date.today()
        params = FieldSyncParams(
            qs=HRProduct.objects.filter(Q(end_date__gte=today) | Q(end_date=None)),
            key_prefix='oebs',
            key_field='product_id',
            translation_ru_field='product_name',
            translation_en_field='product_name',
            startrek_field='productHr2'
        )

        sync = StartrekFieldsSync(params)
        sync.sync()


@app.task(ignore_result=True)
class SyncOccupationFieldTask(LockedTask):
    def locked_run(self, *args, **kwargs):
        today = date.today()
        params = FieldSyncParams(
            qs=Occupation.objects.filter(Q(end_date__gte=today) | Q(end_date=None)),
            key_prefix='oebs',
            key_field='scale_name',
            translation_ru_field='scale_description',
            translation_en_field='scale_description_en',
            startrek_field='occupationTwo',
        )

        sync = StartrekFieldsSync(params)
        sync.sync()
