import yenv
import logging

from ..tasks import (
    GiveBeginnerAchievements,
    GiveRestoredAchievements,
    GiveEmployeeAchievements,
    DepriveBeginnerAchievements,
    DepriveEmployeeAchievements,
    ChangeLevelEmployeeAchievements,
)

logger = logging.getLogger('staff.person.achievements')


def _perform(method):
    def func(person):
        kwargs = {'persons_ids': [person.id]}
        if yenv.type == 'development':
            method(**kwargs)
        else:
            method.apply_async(kwargs=kwargs, countdown=10)
        logger.info(
            'Person with login "%s" %s',
            person.login,
            method.__name__[:-1],
        )
    return func


give_achievement_beginner = _perform(GiveBeginnerAchievements)
give_achievement_restored = _perform(GiveRestoredAchievements)
give_achievement_employee = _perform(GiveEmployeeAchievements)
deprive_achievement_employee = _perform(DepriveEmployeeAchievements)
deprive_achievement_beginner = _perform(DepriveBeginnerAchievements)
change_level_achievement_employee = _perform(ChangeLevelEmployeeAchievements)
