import logging

import yenv

from staff.person.models import PersonBlockActions
from staff.person.passport.internal import IntPassport
from staff.verification.tasks import sync_external_logins as sync_external_logins_task

logger = logging.getLogger(__name__)


def sync_external_logins(person):
    login_eilimination_delay_sec = 30  # откладываем таску отрыва на столько секунд
    kwargs = {
        'person_ids': [person.id],
        'force': True,
    }
    if yenv.type == 'development':
        sync_external_logins_task(**kwargs)
    else:
        sync_external_logins_task.apply_async(kwargs=kwargs, countdown=login_eilimination_delay_sec)


def block_internal_passport(person):
    if yenv.type != 'production':
        logger.info('Do not block %s since we aren\'t in production', person.login)
        return

    try:
        logger.info('Blocking %s', person.login)
        passport = IntPassport(person.uid)
        passport.block()

    except Exception as e:
        logger.error('Failed to block %s', person.login)
        PersonBlockActions.objects.create(
            person_id=person.id,
            is_passport_blocked=False,
            passport_block_last_action_reason=str(e))
        return

    logger.info('Passport for %s blocked', person.login)
    PersonBlockActions.objects.create(person_id=person.id, is_passport_blocked=True)
