from typing import List

import sform

from django.core.exceptions import ValidationError

from staff.person.models import Staff


class ExportPersonInfoForm(sform.SForm):
    MAX_PERSONS_COUNT = 1000

    persons = sform.GridField(
        sform.CharField(max_length=255),
        state=sform.REQUIRED,
    )

    def clean_persons(self, value: List[str]) -> List[str]:
        if len(value) > self.MAX_PERSONS_COUNT:
            raise ValidationError('Too many persons', 'too_many')

        result = list(set(value))

        if len(result) != Staff.objects.filter(login__in=result).count():
            raise ValidationError('Some persons not found', 'invalid_logins')

        return value
