from django import forms

from staff.person.models import StaffExtraFields


class StaffExtraFieldsAdminForm(forms.ModelForm):
    def __init__(self, *args, **kwargs):
        super(StaffExtraFieldsAdminForm, self).__init__(*args, **kwargs)
        not_required_fields = [
            'date_survey_letter',
            'nda_end_date',
            'contract_end_date',
            'oebs_payment_system',
        ]
        for field in not_required_fields:
            self.fields[field].required = False

    class Meta:
        fields = '__all__'
        model = StaffExtraFields
