# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('person_avatar', '0001_initial'),
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Bicycle',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('position', models.IntegerField(default=0)),
                ('plate', models.IntegerField()),
                ('description', models.CharField(max_length=50, default='')),
                ('owner', models.ForeignKey(related_name='bicycles', to='django_intranet_stuff.Staff')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Contact',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('position', models.IntegerField(default=0)),
                ('account_id', models.CharField(max_length=100)),
                ('private', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContactType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('position', models.IntegerField(default=0)),
                ('name', models.CharField(max_length=32)),
                ('name_en', models.CharField(max_length=32, default='')),
                ('icon_url', models.CharField(max_length=256, default='')),
                ('url_pattern', models.CharField(max_length=128, default='')),
                ('validation_type', models.CharField(max_length=10, choices=[('login', 'login'), ('email', 'email'), ('url', 'url')])),
                ('show_in_vcard', models.BooleanField(default=False)),
                ('vcard_template', models.TextField(blank=True, default='')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DiscountCard',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('description', models.CharField(max_length=256)),
                ('number', models.CharField(max_length=64)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('person', models.ForeignKey(to='django_intranet_stuff.Staff')),
            ],
        ),
        migrations.CreateModel(
            name='Occupation',
            fields=[
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('name', models.CharField(verbose_name='Имя (PK)', primary_key=True, max_length=255, serialize=False)),
                ('description', models.CharField(verbose_name='Описание шкалы на русском', max_length=255, blank=True, null=True, db_index=True)),
                ('description_en', models.CharField(verbose_name='Описание шкалы на английском', max_length=255, db_index=True)),
                ('code', models.CharField(verbose_name='Описание шкалы (код)', max_length=255, blank=True, null=True, db_index=True)),
                ('group_femida', models.CharField(verbose_name='Группа (Фемида)', max_length=255, blank=True, null=True)),
                ('group_review', models.CharField(verbose_name='Группа (Ревью)', max_length=255, blank=True, null=True)),
                ('group_bonus', models.CharField(verbose_name='Группа (Премирование)', max_length=255, blank=True, null=True)),
                ('group_reward', models.CharField(verbose_name='Группа (Компенсации)', max_length=255, blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Passport',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('description', models.CharField(max_length=256, blank=True)),
                ('doc_type', models.CharField(max_length=16, choices=[('internal', 'internal'), ('foreign', 'foreign')])),
                ('issue_country', models.CharField(max_length=128)),
                ('country_code', models.CharField(max_length=16, blank=True)),
                ('number', models.CharField(max_length=64)),
                ('issue_date', models.DateField()),
                ('expire_date', models.DateField(null=True)),
                ('issued_by', models.CharField(max_length=256)),
                ('first_name', models.CharField(max_length=50)),
                ('last_name', models.CharField(max_length=100)),
                ('middle_name', models.CharField(max_length=100, blank=True)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('person', models.ForeignKey(to='django_intranet_stuff.Staff')),
            ],
        ),
        migrations.CreateModel(
            name='PaymentSystem',
            fields=[
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('name', models.CharField(primary_key=True, max_length=255, unique=True, serialize=False)),
                ('description', models.CharField(max_length=512, blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='PersonBlockActions',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('is_passport_blocked', models.BooleanField(default=False)),
                ('passport_block_last_action_timestamp', models.DateTimeField(auto_now=True)),
                ('passport_block_last_action_reason', models.TextField(blank=True, null=True)),
                ('person', models.ForeignKey(to='django_intranet_stuff.Staff')),
            ],
        ),
        migrations.CreateModel(
            name='ResponsibleForRobot',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('role', models.CharField(max_length=10, choices=[('owner', 'owner'), ('user', 'user')])),
                ('responsible', models.ForeignKey(related_name='robots', to='django_intranet_stuff.Staff')),
                ('robot', models.ForeignKey(related_name='responsibles', to='django_intranet_stuff.Staff')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StaffExtraFields',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('nda_end_date', models.DateField(null=True)),
                ('contract_end_date', models.DateField(null=True)),
                ('byod_access', models.BooleanField(default=False)),
                ('wiretap', models.BooleanField(default=False)),
                ('staff_agreement', models.BooleanField(default=False)),
                ('oebs_first_name', models.CharField(verbose_name='Имя сотрудника', max_length=255, blank=True, default='')),
                ('oebs_middle_name', models.CharField(verbose_name='Отчество сотрудника', max_length=255, blank=True, default='')),
                ('oebs_last_name', models.CharField(verbose_name='Фамилия сотрудника', max_length=255, blank=True, default='')),
                ('oebs_address', models.CharField(verbose_name='Адрес проживания', max_length=255, blank=True, default='')),
                ('oebs_manage_org_name', models.CharField(verbose_name='Кадровое наименование подразделения', max_length=255, blank=True, default='')),
                ('oebs_headcount', models.BooleanField(default=False)),
                ('date_survey_letter', models.DateField(null=True)),
                ('is_welcome_mail_sent', models.BooleanField(default=False)),
                ('is_offer_avatar_uploaded', models.BooleanField(default=False)),
                ('last_vacation_accrual_at', models.DateField(null=True, auto_now_add=True)),
                ('avatar_img_for_upload', models.ForeignKey(null=True, related_name='avatar_img', to='person_avatar.AvatarMetadata')),
                ('gravatar_img_for_upload', models.ForeignKey(null=True, related_name='gravarar_img', to='person_avatar.AvatarMetadata')),
                ('main_img_for_upload', models.ForeignKey(null=True, related_name='main_img', to='person_avatar.AvatarMetadata')),
                ('occupation', models.ForeignKey(null=True, to='person.Occupation')),
                ('oebs_payment_system', models.ForeignKey(null=True, default=None, to='person.PaymentSystem')),
                ('staff', models.OneToOneField(related_name='extra', to='django_intranet_stuff.Staff')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Visa',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('description', models.CharField(max_length=256, blank=True)),
                ('country', models.CharField(max_length=128)),
                ('number', models.CharField(max_length=64)),
                ('is_multiple', models.BooleanField(default=False)),
                ('issue_date', models.DateField()),
                ('expire_date', models.DateField(null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('person', models.ForeignKey(to='django_intranet_stuff.Staff')),
            ],
        ),
        migrations.CreateModel(
            name='WelcomeEmailTemplate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('text', models.TextField(blank=True)),
                ('text_en', models.TextField(blank=True)),
            ],
        ),
        migrations.AddField(
            model_name='contact',
            name='contact_type',
            field=models.ForeignKey(to='person.ContactType'),
        ),
        migrations.AddField(
            model_name='contact',
            name='person',
            field=models.ForeignKey(to='django_intranet_stuff.Staff'),
        ),
    ]
