from django.db import models

from staff.lib.utils.ordered_choices import OrderedChoices


PASSPORT_TYPE = OrderedChoices(
    ('INTERNAL', 'internal'),
    ('FOREIGN', 'foreign'),
)


class Passport(models.Model):
    person = models.ForeignKey('django_intranet_stuff.Staff', on_delete=models.CASCADE)

    description = models.CharField(max_length=256, blank=True)

    doc_type = models.CharField(max_length=16, choices=PASSPORT_TYPE.choices())

    issue_country = models.CharField(max_length=128)
    country_code = models.CharField(max_length=16, blank=True)

    number = models.CharField(max_length=64)
    issue_date = models.DateField()
    expire_date = models.DateField(null=True)
    issued_by = models.CharField(max_length=256)

    first_name = models.CharField(max_length=50)
    last_name = models.CharField(max_length=100)
    middle_name = models.CharField(max_length=100, blank=True)

    is_active = models.BooleanField(default=True)
    created_at = models.DateTimeField(auto_now_add=True, editable=False)
    modified_at = models.DateTimeField(auto_now=True, editable=False)


class Visa(models.Model):
    person = models.ForeignKey('django_intranet_stuff.Staff', on_delete=models.CASCADE)

    description = models.CharField(max_length=256, blank=True)
    country = models.CharField(max_length=128)
    number = models.CharField(max_length=64)
    is_multiple = models.BooleanField(default=False)
    issue_date = models.DateField()
    expire_date = models.DateField(null=True)

    is_active = models.BooleanField(default=True)
    created_at = models.DateTimeField(auto_now_add=True, editable=False)
    modified_at = models.DateTimeField(auto_now=True, editable=False)


class DiscountCard(models.Model):
    person = models.ForeignKey('django_intranet_stuff.Staff', on_delete=models.CASCADE)

    description = models.CharField(max_length=256)
    number = models.CharField(max_length=64)

    is_active = models.BooleanField(default=True)
    created_at = models.DateTimeField(auto_now_add=True, editable=False)
    modified_at = models.DateTimeField(auto_now=True, editable=False)
