from django.db import models

from staff.lib.models.base import SortedModel, IntranetModel, AtomicSaveModel


class Bicycle(SortedModel, AtomicSaveModel):
    owner = models.ForeignKey('django_intranet_stuff.Staff', related_name='bicycles')
    plate = models.IntegerField()
    description = models.CharField(max_length=50, default='')


class StaffCar(IntranetModel, SortedModel):
    staff = models.ForeignKey('Staff', related_name='cars')
    model = models.CharField(max_length=100, default='')
    plate = models.CharField(max_length=50, default='')

    def __str__(self):
        return '%s with number plate %s, owner is %s' % (self.model, self.plate, self.staff)

    class Meta(IntranetModel.Meta):
        db_table = 'intranet_staff_car'
