from django.db import models
from staff.lib.models.base import IntranetModel


class Occupation(IntranetModel):
    name = models.CharField(
        primary_key=True,
        max_length=255,
        verbose_name='Имя (PK)',
    )
    description = models.CharField(
        max_length=255,
        verbose_name='Описание шкалы на русском',
        db_index=True,
        null=True,
        blank=True,
    )
    description_en = models.CharField(
        max_length=255,
        verbose_name='Описание шкалы на английском',
        db_index=True,
    )
    code = models.CharField(
        max_length=255,
        verbose_name='Описание шкалы (код)',
        db_index=True,
        null=True,
        blank=True,
    )
    group_femida = models.CharField(
        null=True,
        blank=True,
        max_length=255,
        verbose_name='Группа (Фемида)',
    )
    group_review = models.CharField(
        null=True,
        blank=True,
        max_length=255,
        verbose_name='Группа (Ревью)',
    )
    group_bonus = models.CharField(
        null=True,
        blank=True,
        max_length=255,
        verbose_name='Группа (Премирование)',
    )
    group_reward = models.CharField(
        null=True,
        blank=True,
        max_length=255,
        verbose_name='Группа (Компенсации)',
    )

    def __str__(self):
        return '{name} ({description})'.format(**vars(self))

    class Meta:
        app_label = 'person'
