from django.conf import settings
from django.db import models

from staff.lib.models.base import IntranetModel, SortedModel


class Organization(IntranetModel, SortedModel):
    city = models.ForeignKey('City', null=True, blank=True)

    from_staff_id = models.PositiveIntegerField(db_index=True)
    name = models.CharField(max_length=50)
    name_en = models.CharField(max_length=50)
    chief = models.CharField(max_length=50, default='')
    deputy = models.CharField(max_length=50, default='')
    color = models.CharField(max_length=10, default='')
    textcolor = models.CharField(max_length=10, default='')
    filter_id = models.CharField(max_length=40, default='', blank=True)
    st_translation_id = models.IntegerField(null=True, blank=True, verbose_name='id от объекта translation из startrek')
    country_code = models.CharField(max_length=3, blank=True, default='')

    def __str__(self):
        return self.name

    class Meta(IntranetModel.Meta):
        db_table = 'intranet_organization'

    _OUTSTAFF_ORG = None

    @classmethod
    def get_outstaff_org(cls):
        if cls._OUTSTAFF_ORG is None:
            cls._OUTSTAFF_ORG = Organization.objects.get(id=settings.ROBOTS_ORGANIZATION_ID)
        return cls._OUTSTAFF_ORG
