import codecs
import itertools

from staff.person_filter.filter_context import FilterContext
from django.contrib.auth.decorators import permission_required
from django.http.request import QueryDict
from staff.departments.tree.persons_export import ExportForm, PersonsExport
from staff.lib.decorators import responding_xlsx, make_xlsx_response, responding_csv

from staff.person.reports.objects import StaffReport, StaffUmbrellasReport


@permission_required('django_intranet_stuff.can_view_persons_report', raise_exception=True)
@responding_xlsx(prefix='staff-report')
def staff_report(request):
    return [StaffReport().as_table()]


@permission_required('django_intranet_stuff.can_view_persons_report', raise_exception=True)
@responding_csv(filename='staff-report-csv', separator=';', encoding='utf-8', bom=codecs.BOM_UTF8)
def staff_report_csv(request):
    report = StaffReport()
    return itertools.chain(report.get_head_rows(), report.get_rows())


@permission_required('django_intranet_stuff.can_view_persons_report', raise_exception=True)
@responding_csv(filename='staff-umbrellas-report-csv', separator=';', encoding='utf-8', bom=codecs.BOM_UTF8)
def staff_umbrellas_report_csv(request):
    report = StaffUmbrellasReport()
    return itertools.chain(report.get_head_rows(), report.get_rows())


@permission_required('django_intranet_stuff.can_view_persons_report', raise_exception=True)
@responding_xlsx(prefix='staff-workplace-report')
def staff_workplace_report(request):
    data = QueryDict("lang=ru&login=on&name=on&table=on&office=on&department_chain=on&data_format=xlsx")
    form = ExportForm(data=data)

    file_name = 'persons_workplace_report'

    if form.is_valid():
        data = PersonsExport(FilterContext(), None, form).export()
        return make_xlsx_response(file_name=None, prefix=file_name, data=[[file_name, data]])
