from staff.celery_app import app
from staff.lib.tasks import LockedTask
from staff.lib.sync_tools.st_translation_sync import FieldSyncParams, StartrekFieldsSync
from staff.person.models import Organization


@app.task(ignore_result=True)
class SyncOrganizationFieldTask(LockedTask):
    def locked_run(self, *args, **kwargs):
        params = FieldSyncParams(
            qs=Organization.objects.filter(intranet_status=1),
            key_prefix='staff',
            key_field='id',
            translation_ru_field='name',
            translation_en_field='name_en',
            startrek_field='legalEntity2',
        )

        sync = StartrekFieldsSync(params)
        sync.sync()
