import logging

from django.conf import settings

from staff.lib import requests, tvm2
from staff.celery_app import app
from staff.lib.tasks import LockedTask

logger = logging.getLogger('person.tasks.yandex_disk')


@app.task(ignore_result=True)
class ActualizeYandexDisk(LockedTask):
    def get_lock_name(self, *args, **kwargs):
        person_uid = kwargs.get('person_uid', args and args[0])
        return f'ActualizeYandexDisk_{person_uid}'

    def locked_run(self, *args, **kwargs):
        person_uid = kwargs.get('person_uid', args and args[0])
        person_login = kwargs.get('person_login', '?')

        try:
            result = requests.get(
                f'http://{settings.YA_DISK_HOST}/json/staff_user_changed_callback',
                {'yateam_uid': person_uid},
                headers={tvm2.TVM_SERVICE_TICKET_HEADER: tvm2.get_tvm_ticket_by_deploy(*settings.YA_DISK_TVM)},
                timeout=(0.5, 1, 4)
            )
            result.raise_for_status()
        except Exception as exc:
            logger.info('Unhandled exception on ActualizeYandexDisk for login %s', person_login, exc_info=True)
            self.retry(countdown=600, exc=exc)
