from django.contrib import admin

from staff.lib.utils.admin import StaffModelAdmin
from .models import AvatarMetadata


class AvatarMetadataAdmin(StaffModelAdmin):
    staff_field = 'person'
    list_display = ('person', 'preprofile', 'is_main', 'is_avatar', 'is_deleted')
    list_filter = ('is_avatar', 'is_main', 'is_deleted')


admin.site.register(AvatarMetadata, AvatarMetadataAdmin)
