import logging
from staff.person.models import StaffExtraFields
from .base import BaseAvatar, BaseAvatarCollection, MAIN, AVATAR
from staff.person_avatar.models import AvatarMetadata

logger = logging.getLogger(__name__)


class PersonAvatar(BaseAvatar):
    metadata_owner_field = 'person'

    @property
    def owner_login(self):
        return self.owner.login

    @property
    def owner_work_email(self):
        return self.owner and self.owner.work_email

    def get_extrafields_instance(self):
        return (
            StaffExtraFields.objects
            .get_or_create(staff=self.owner)
        )[0]


class PersonAvatarCollection(BaseAvatarCollection):
    avatar_class = PersonAvatar

    AVATARS_MAX_COUNT = 5

    def __init__(self, owner=None, by_metadata_id=None):
        if by_metadata_id:
            owner = (
                AvatarMetadata.objects
                .select_related('person')
                .get(id=by_metadata_id)
                .person
            )
        super(PersonAvatarCollection, self).__init__(owner=owner)

    def post_upload(self, new_avatar):
        if self.count() == 1:
            self.make(new_avatar.id, [MAIN, AVATAR])

        if self.count() > self.AVATARS_MAX_COUNT:
            self.delete(self.owner_avatars[0].id)
