# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('preprofile', '0001_initial'),
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AvatarMetadata',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('is_main', models.BooleanField(default=False)),
                ('is_avatar', models.BooleanField(default=False)),
                ('is_deleted', models.BooleanField(db_index=True, default=True)),
                ('person', models.ForeignKey(blank=True, null=True, default=None, to='django_intranet_stuff.Staff')),
                ('preprofile', models.ForeignKey(blank=True, null=True, default=None, to='preprofile.Preprofile')),
            ],
        ),
        migrations.CreateModel(
            name='PreprofileExtraFields',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('avatar_img_for_upload', models.ForeignKey(null=True, related_name='preprofile_avatar_img', to='person_avatar.AvatarMetadata')),
                ('gravatar_img_for_upload', models.ForeignKey(null=True, related_name='preprofile_gravarar_img', to='person_avatar.AvatarMetadata')),
                ('main_img_for_upload', models.ForeignKey(null=True, related_name='preprofile_main_img', to='person_avatar.AvatarMetadata')),
                ('preprofile', models.OneToOneField(related_name='extra', to='preprofile.Preprofile')),
            ],
        ),
    ]
