# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('person_avatar', '0001_initial'),
    ]

    operations = [
        migrations.RunSQL(
            sql='''
WITH duplicates AS (SELECT person_id, MIN(id) AS id FROM person_avatar_avatarmetadata
    WHERE person_id IS NOT NULL AND is_main AND NOT is_deleted
    GROUP BY person_id
    HAVING COUNT(1) > 1)
UPDATE person_avatar_avatarmetadata AS metadata
    SET is_main = FALSE
    FROM duplicates
    WHERE metadata.person_id = duplicates.person_id AND metadata.id != duplicates.id;
''',
        ),
        migrations.RunSQL(
            sql='CREATE UNIQUE INDEX person_avatar_avatarmetadata_person_is_main ON person_avatar_avatarmetadata(person_id) WHERE is_main AND NOT is_deleted;',
            reverse_sql='DROP INDEX person_avatar_avatarmetadata_person_is_main;',
        ),
    ]
