from django.db import models

from staff.person.models import Staff


class AvatarMetadata(models.Model):

    person = models.ForeignKey(
        'django_intranet_stuff.Staff',
        null=True,
        blank=True,
        default=None,
    )
    preprofile = models.ForeignKey(
        'preprofile.Preprofile',
        null=True,
        blank=True,
        default=None,
    )
    is_main = models.BooleanField(default=False)
    is_avatar = models.BooleanField(default=False)  # Также для граватаров
    is_deleted = models.BooleanField(default=True, db_index=True)

    def __str__(self):
        try:
            msg = 'Metadata {} for image for person_id={}, preprofile_id={}'
            return msg.format(self.id, self.person_id, self.preprofile_id)
        except Staff.DoesNotExist:
            return 'Unbound avatar image'


class PreprofileExtraFields(models.Model):

    preprofile = models.OneToOneField(
        'preprofile.Preprofile',
        related_name='extra',
    )

    main_img_for_upload = models.ForeignKey(
        AvatarMetadata,
        related_name='preprofile_main_img',
        null=True,
    )
    avatar_img_for_upload = models.ForeignKey(
        AvatarMetadata,
        related_name='preprofile_avatar_img',
        null=True,
    )
    gravatar_img_for_upload = models.ForeignKey(
        AvatarMetadata,
        related_name='preprofile_gravarar_img',
        null=True,
    )
