from django.contrib import admin

from staff.lib.utils.admin import StaffModelAdmin, BaseIntranetAdmin
from .models import PersonsFilter, SavedPersonsFilter


class SavedPersonsFilterAdmin(StaffModelAdmin):
    staff_field = 'person'
    list_display = (
        'name',
        'person',
        'is_bookmark',
        'is_for_cab',
        'absences_subscription',
        'birthdays_subscription',
    )
    readonly_fields = 'persons_filter',
    list_filter = (
        'is_bookmark',
        'is_for_cab',
        'absences_subscription',
        'birthdays_subscription',
    )
    search_fields = 'persons_filter__filter_id', 'name'


class PersonsFilterAdmin(BaseIntranetAdmin):
    list_display = (
        'filter_id',
        'person',
        'department',
        'persons_count',
        'result_hash',
    )
    readonly_fields = 'filter_id', 'person', 'department'
    fields = list_display


admin.site.register(SavedPersonsFilter, SavedPersonsFilterAdmin)
admin.site.register(PersonsFilter, PersonsFilterAdmin)
