import sform
from collections import OrderedDict

from staff.lib.utils.ordered_choices import OrderedChoices
from staff.lib.utils.library import Library


lib = Library(lambda o: o.__name__)


OPERATORS = OrderedChoices(
    ('AND', 'and'),
    ('OR', 'or'),
)


class FieldFilter(object):
    conditions = None
    _form_cls = None

    @classmethod
    def register(cls, condition):
        if cls.conditions is None:
            cls.conditions = OrderedDict()
        cls.conditions[condition.__name__] = condition
        return condition

    @classmethod
    def as_meta_dict(cls):
        result = cls.get_form_cls()().structure_as_dict(prefix='filters[0]')
        result['forms'] = {
            f.__name__: f.form_cls().structure_as_dict(prefix='filters[0]')
            for f in cls.conditions.values()
        }
        return result

    @classmethod
    def get_form_cls(cls):
        if cls._form_cls is None:
            conditions = list(cls.conditions.keys())

            class ConditionForm(sform.SForm):
                condition = sform.ChoiceField(
                    choices=[[f] * 2 for f in conditions],
                    state=sform.REQUIRED,
                    default=conditions[0],
                )
            cls._form_cls = ConditionForm
        return cls._form_cls


class Condition(object):
    hidden = False

    def __init__(self, cleaned_data=None):
        self.cleaned_data = cleaned_data

    @property
    def name(self):
        return self.__class__.__name__


class BaseExistence(Condition):
    pass


class BaseEqual(Condition):
    pass


class BaseContains(Condition):
    pass


class BaseIn(Condition):
    pass


class BaseInHierarchy(Condition):
    pass


class BaseGreater(Condition):
    pass


class BaseRange(Condition):
    pass


class BaseDayMonthYear(Condition):
    pass
