from django.core.exceptions import ValidationError

import sform


VALUE_IS_REQUIRED = 'required'


class TrueBooleanForm(sform.SForm):
    value = sform.BooleanField(default=True)


class FalseBooleanForm(sform.SForm):
    value = sform.BooleanField(default=False)


class DateForm(sform.SForm):
    date = sform.DateField(state=sform.REQUIRED)


class DateRangeForm(sform.SForm):
    start = sform.DateField()
    end = sform.DateField()

    def clean(self):
        cd = self.cleaned_data
        if not (cd['start'] or cd['end']):
            raise ValidationError(VALUE_IS_REQUIRED, code=VALUE_IS_REQUIRED)
        return cd


MONTHS = (
    (1, 'january'),
    (2, 'february'),
    (3, 'march'),
    (4, 'april'),
    (5, 'may'),
    (6, 'june'),
    (7, 'july'),
    (8, 'august'),
    (9, 'september'),
    (10, 'october'),
    (11, 'november'),
    (12, 'december'),
)


DAYS = tuple((n, n) for n in range(1, 32))


class DayMonthYearForm(sform.SForm):
    day = sform.ChoiceField(choices=DAYS, empty_label='empty')
    month = sform.ChoiceField(choices=MONTHS, empty_label='empty')
    year = sform.IntegerField(min_value=1900, max_value=9999)

    def clean(self):
        cd = self.cleaned_data
        if self.errors:
            return cd
        if not (cd['day'] or cd['month'] or cd['year']):
            raise ValidationError(VALUE_IS_REQUIRED, code=VALUE_IS_REQUIRED)
        return cd


class CharForm(sform.SForm):
    value = sform.CharField(state=sform.REQUIRED)


class IntForm(sform.SForm):
    value = sform.IntegerField(state=sform.REQUIRED)
