import sform

from django.db.models import Q

from staff.groups.models import Group, GroupMembership, GROUP_TYPE_CHOICES

from ._base import lib, FieldFilter, BaseEqual, BaseIn


@lib.register
class ServiceFilter(FieldFilter):
    """Сервис, равно/в списке, саджест по сервисам"""


class SuggestField(sform.SuggestField):
    def structure_as_dict(self, *args, **kwargs):
        field_dict = super(SuggestField, self).structure_as_dict(*args, **kwargs)
        field_dict['types'] = ['services']
        return field_dict


class EqualForm(sform.SForm):
    group = SuggestField(
        queryset=Group.objects.filter(
            intranet_status=1,
            type=GROUP_TYPE_CHOICES.SERVICE,
        ),
        label_fields='name',
        state=sform.REQUIRED,
    )


@ServiceFilter.register
class Equal(BaseEqual):
    form_cls = EqualForm

    def q(self):
        return Q(id__in=(
            GroupMembership.objects
            .filter(group_id=self.cleaned_data['group'])
            .values('staff_id')
        ))


@ServiceFilter.register
class Exclude(Equal):
    def q(self):
        return ~ super(Exclude, self).q()


class MultipleSuggestField(sform.MultipleSuggestField):
    def structure_as_dict(self, *args, **kwargs):
        field_dict = super(MultipleSuggestField, self).structure_as_dict(*args, **kwargs)
        field_dict['types'] = ['services']
        return field_dict


class InForm(sform.SForm):
    groups = MultipleSuggestField(
        queryset=Group.objects.filter(
            intranet_status=1,
            type=GROUP_TYPE_CHOICES.SERVICE,
        ),
        label_fields='name',
        state=sform.REQUIRED,
    )


# @ServiceFilter.register
class In(BaseIn):
    form_cls = InForm

    def q(self):
        return Q(id__in=(
            GroupMembership.objects
            .filter(group_id__in=self.cleaned_data['groups'])
            .values('staff_id')
        ))
