from django.db.models import Q

import sform

from ._base import lib, FieldFilter, BaseEqual

from staff.person.models import AFFILIATION


@lib.register
class AffiliationFilter(FieldFilter):
    """Принадлежность, равно, список"""


class EqualForm(sform.SForm):
    affiliation = sform.ChoiceField(
        choices=[(d[0], d[0]) for d in AFFILIATION],
        state=sform.REQUIRED,
    )


@AffiliationFilter.register
class Equal(BaseEqual):
    form_cls = EqualForm
    hidden = True

    def q(self):
        return Q(affiliation=self.cleaned_data['affiliation'])


@AffiliationFilter.register
class Exclude(Equal):
    def q(self):
        return ~ super(Exclude, self).q()
