import sform

from django.db.models import Q

from staff.map.models import Office

from ._base import lib, FieldFilter, BaseEqual, BaseIn


@lib.register
class OfficeFilter(FieldFilter):
    """Офис, равно/в списке, селект"""


class EqualForm(sform.SForm):
    office = sform.ModelChoiceField(
        queryset=Office.objects.filter(intranet_status=1),
        label_extractor='name',
        state=sform.REQUIRED,
    )


@OfficeFilter.register
class Equal(BaseEqual):
    form_cls = EqualForm

    def q(self):
        return Q(office=self.cleaned_data['office'])


@OfficeFilter.register
class Exclude(Equal):
    def q(self):
        return ~ super(Exclude, self).q()


class InForm(sform.SForm):
    offices = sform.ModelMultipleChoiceField(
        queryset=Office.objects.filter(intranet_status=1),
        label_extractor='name',
        state=sform.REQUIRED,
    )


# @OfficeFilter.register
class In(BaseIn):
    form_cls = InForm

    def q(self):
        return Q(office__in=self.cleaned_data['offices'])
