import sform

from django.db.models import Q

from staff.map.models import Room

from ._base import lib, FieldFilter, BaseEqual


@lib.register
class RoomFilter(FieldFilter):
    """Комната, равно, саджест"""


class EqualForm(sform.SForm):
    room = sform.SuggestField(
        state=sform.REQUIRED,
        queryset=Room.objects.filter(intranet_status=1),
        label_fields=('num', 'name'),
    )


@RoomFilter.register
class Equal(BaseEqual):
    form_cls = EqualForm

    def q(self):
        return Q(room=self.cleaned_data['room'])


@RoomFilter.register
class Exclude(Equal):
    def q(self):
        return ~ super(Exclude, self).q()
