import sform

from django.db.models import Q

from staff.map.models import Country, Office

from ._base import lib, FieldFilter, BaseEqual, BaseIn


# Для формы можно определить на уровне модуля.
country_qs = (
    Country.objects
    .filter(
        intranet_status=1,
        id__in=Office.objects.filter(intranet_status=1).values('city__country'),
    )
)


@lib.register
class CountryFilter(FieldFilter):
    """Страна офиса, равно/в списке, селект"""


class EqualForm(sform.SForm):
    country = sform.ModelChoiceField(
        queryset=country_qs,
        label_extractor='name',
        state=sform.REQUIRED,
    )


@CountryFilter.register
class Equal(BaseEqual):
    form_cls = EqualForm

    def q(self):
        return Q(office__city__country=self.cleaned_data['country'])


@CountryFilter.register
class Exclude(Equal):
    def q(self):
        return ~ super(Exclude, self).q()


class InForm(sform.SForm):
    countries = sform.ModelMultipleChoiceField(
        queryset=country_qs,
        label_extractor='name',
        state=sform.REQUIRED,
    )


# @CountryFilter.register
class In(BaseIn):
    form_cls = InForm

    def q(self):
        return Q(office__city__country__in=self.cleaned_data['countries'])
