from django.db.models import Q

from . import _forms
from ._base import lib, FieldFilter, BaseContains


@lib.register
class PositionFilter(FieldFilter):
    """Должность, содержит, инпут"""


@PositionFilter.register
class Contains(BaseContains):
    form_cls = _forms.CharForm

    def q(self):
        return (
            Q(position__icontains=self.cleaned_data['value'])
            | Q(position_en__icontains=self.cleaned_data['value'])
        )


@PositionFilter.register
class NotContains(Contains):
    def q(self):
        return ~ super(NotContains, self).q()
