from django.db.models import Q

from staff.person.models import Staff

import sform

from ._base import lib, FieldFilter, BaseEqual


@lib.register
class PersonFilter(FieldFilter):
    """Сотрудники, в списке, саджест по сотрудникам"""


class EqualForm(sform.SForm):
    person = sform.SuggestField(
        queryset=Staff.objects.all(),
        label_fields=('first_name', 'last_name'),
        state=sform.REQUIRED,
    )


@PersonFilter.register
class Equal(BaseEqual):
    form_cls = EqualForm

    def q(self):
        return Q(
            is_dismissed=False,
            id=self.cleaned_data['person'].id,
        )


@PersonFilter.register
class Exclude(Equal):
    def q(self):
        return ~ super(Exclude, self).q()
