import sform

from django.db.models import Q

from staff.departments.models import Department, DepartmentStaff, DepartmentRoles

from . import _forms
from ._base import lib, FieldFilter, BaseEqual, BaseInHierarchy


@lib.register
class ChiefFilter(FieldFilter):
    """Руководитель, является да/нет, в/не в иерархии саджест"""


@ChiefFilter.register
class Equal(BaseEqual):
    form_cls = _forms.TrueBooleanForm

    def q(self):
        return Q(is_big_boss=self.cleaned_data['value'])


class EqualForm(sform.SForm):
    department = sform.SuggestField(
        queryset=Department.objects.all(),
        label_fields='name',
        state=sform.REQUIRED,
    )


@ChiefFilter.register
class InHierarchy(BaseInHierarchy):
    form_cls = EqualForm

    def q(self):
        dep = self.cleaned_data['department']
        q = Q(id__in=(
            DepartmentStaff.objects
            .filter(
                department__tree_id=dep.tree_id,
                department__lft__gte=dep.lft,
                department__rght__lte=dep.rght,
                role_id__in=(DepartmentRoles.CHIEF.value, DepartmentRoles.GENERAL_DIRECTOR.value),
            )
            .values('staff_id')
        ))
        return q


@ChiefFilter.register
class InHierarchyExclude(InHierarchy):
    def q(self):
        return Q(is_big_boss=True) & (~ super(InHierarchyExclude, self).q())
