from django.db.models import Q

from staff.departments.models import DepartmentStaff, DepartmentRoles

from . import _forms
from ._base import lib, FieldFilter, BaseEqual


@lib.register
class DeputyFilter(FieldFilter):
    """Заместитель, [равно], да/нет"""


@DeputyFilter.register
class Equal(BaseEqual):
    form_cls = _forms.TrueBooleanForm
    hidden = True

    def q(self):
        q = Q(id__in=(
            DepartmentStaff.objects
            .filter(role_id=DepartmentRoles.DEPUTY.value)
            .values('staff_id')
        ))
        return q if self.cleaned_data['value'] else ~q
