import sform

from staff.person.models import Staff

from staff.person_profile.controllers.subordinates import (
    direct_subordinates_q,
    all_subordinates_q,
)

from ._base import lib, FieldFilter, Condition


@lib.register
class SubordinatesFilter(FieldFilter):
    """Подчиненные указанного руководителя"""


class EqualForm(sform.SForm):
    person = sform.SuggestField(
        queryset=Staff.objects.filter(is_dismissed=False),
        label_fields=('first_name', 'last_name'),
        state=sform.REQUIRED,
    )


@SubordinatesFilter.register
class Direct(Condition):
    form_cls = EqualForm

    def q(self):
        return direct_subordinates_q(self.cleaned_data['person'].id)


@SubordinatesFilter.register
class All(Condition):
    form_cls = EqualForm

    def q(self):
        return all_subordinates_q(self.cleaned_data['person'].id)
