import sform

from datetime import datetime, timedelta

from django.db.models import Q

from staff.lib.utils.ordered_choices import OrderedChoices

from ._base import lib, FieldFilter, BaseGreater


INTERVALS = OrderedChoices(
    ('MIN15', '15min'),
    ('HOUR', 'hour'),
    ('DAY', 'day'),
    ('WEEK', 'week'),
)

TD_INTERVALS = {
    INTERVALS.MIN15: timedelta(minutes=15),
    INTERVALS.HOUR: timedelta(hours=1),
    INTERVALS.DAY: timedelta(days=1),
    INTERVALS.WEEK: timedelta(weeks=1),
}


@lib.register
class LastActivityFilter(FieldFilter):
    """Последняя активность, [равно], 15 минут/час/день/неделя"""


class GreaterForm(sform.SForm):
    interval = sform.ChoiceField(choices=INTERVALS, state=sform.REQUIRED, default=INTERVALS.MIN15)


@LastActivityFilter.register
class Greater(BaseGreater):
    form_cls = GreaterForm

    def q(self):
        interval = TD_INTERVALS[self.cleaned_data['interval']]
        stamp = datetime.now() - interval
        return Q(stafflastoffice__updated_at__gte=stamp)
