import sform

from django.db.models import Q

from staff.person.models import Organization

from ._base import lib, FieldFilter, BaseEqual, BaseIn


@lib.register
class OrganizationFilter(FieldFilter):
    """Организация, равно/в списке, селект"""


class EqualForm(sform.SForm):
    organization = sform.ModelChoiceField(
        queryset=Organization.objects.filter(intranet_status=1),
        label_extractor='name',
        state=sform.REQUIRED,
    )


@OrganizationFilter.register
class Equal(BaseEqual):
    form_cls = EqualForm

    def q(self):
        return Q(organization=self.cleaned_data['organization'])


@OrganizationFilter.register
class Exclude(Equal):
    def q(self):
        return ~ super(Exclude, self).q()


class InForm(sform.SForm):
    organizations = sform.ModelMultipleChoiceField(
        queryset=Organization.objects.filter(intranet_status=1),
        label_extractor='name',
        state=sform.REQUIRED,
    )


# @OrganizationFilter.register
class In(BaseIn):
    form_cls = InForm

    def q(self):
        return Q(organization__in=self.cleaned_data['organizations'])
