import sform

from django.db.models import Q

from staff.person.models import EMPLOYMENT

from ._base import lib, FieldFilter, BaseEqual, BaseIn


EMPLOYMENTS = [[EMPLOYMENT.get_name(e[0]).lower()] * 2 for e in EMPLOYMENT]


@lib.register
class EmploymentFilter(FieldFilter):
    """Форма занятости, равно, селект"""


class EqualForm(sform.SForm):
    employment = sform.ChoiceField(
        choices=EMPLOYMENTS,
        state=sform.REQUIRED,
    )


@EmploymentFilter.register
class Equal(BaseEqual):
    form_cls = EqualForm

    def q(self):
        return Q(employment=getattr(
            EMPLOYMENT, self.cleaned_data['employment'].upper()
        ))


@EmploymentFilter.register
class Exclude(Equal):
    def q(self):
        return ~ super(Exclude, self).q()


class InForm(sform.SForm):
    employments = sform.MultipleChoiceField(
        choices=EMPLOYMENTS,
        state=sform.REQUIRED,
    )


# @EmploymentFilter.register
class In(BaseIn):
    form_cls = InForm

    def q(self):
        return Q(employment__in=getattr(
            EMPLOYMENT, self.cleaned_data['employment'].upper()
        ))
