from django.db.models import Q

from . import _forms
from ._base import lib, FieldFilter, BaseEqual


@lib.register
class HomeworkerFilter(FieldFilter):
    """Надомник, [равно], да/нет"""


@HomeworkerFilter.register
class Equal(BaseEqual):
    form_cls = _forms.FalseBooleanForm
    hidden = True

    def q(self):
        return Q(is_homeworker=self.cleaned_data['value'])
