from django.db.models import Q

from . import _forms
from ._base import lib, FieldFilter, BaseEqual


@lib.register
class RobotFilter(FieldFilter):
    """Робот, [равно], да/нет"""


@RobotFilter.register
class Equal(BaseEqual):
    form_cls = _forms.FalseBooleanForm
    hidden = True

    def q(self):
        return Q(is_robot=self.cleaned_data['value'])
