from django.db.models import Q

from . import _forms
from ._base import lib, FieldFilter, BaseRange, BaseDayMonthYear, BaseEqual


@lib.register
class JoinAtFilter(FieldFilter):
    """Дата выхода на работу, число-месяц-год/с-по/равно, 3 инпута/ ввод двух датв календарике / дата"""


@JoinAtFilter.register
class Range(BaseRange):
    form_cls = _forms.DateRangeForm

    def q(self):
        q = Q()
        if self.cleaned_data['start']:
            q &= Q(join_at__gte=self.cleaned_data['start'])

        if self.cleaned_data['end']:
            q &= Q(join_at__lte=self.cleaned_data['end'])

        return q


@JoinAtFilter.register
class Equal(BaseEqual):
    form_cls = _forms.DateForm

    def q(self):
        return Q(join_at=self.cleaned_data['date'])


@JoinAtFilter.register
class DayMonthYear(BaseDayMonthYear):
    form_cls = _forms.DayMonthYearForm

    def q(self):
        day = self.cleaned_data['day']
        month = self.cleaned_data['month']
        year = self.cleaned_data['year']

        q = Q()

        if day:
            q &= Q(join_at__day=day)
        if month:
            q &= Q(join_at__month=month)
        if year:
            q &= Q(join_at__year=year)

        return q
