from datetime import date, timedelta

from django.conf import settings
from django.db.models import Q

from . import _forms
from ._base import lib, FieldFilter, BaseEqual


@lib.register
class BeginnerFilter(FieldFilter):
    """Новый сотрудник, [равно], да/нет"""


@BeginnerFilter.register
class Equal(BaseEqual):
    form_cls = _forms.TrueBooleanForm
    hidden = True

    def q(self):
        q = Q(join_at__gt=date.today() - timedelta(settings.BEGINNER_DAYS))
        return q if self.cleaned_data['value'] else ~q
