from django.db.models import Q

from staff.person.models import StaffCar

from . import _forms
from ._base import lib, FieldFilter, BaseEqual


@lib.register
class HasAutoFilter(FieldFilter):
    """Наличие автомобиля, [равно], да/нет"""


@HasAutoFilter.register
class Equal(BaseEqual):
    form_cls = _forms.TrueBooleanForm
    hidden = True

    def q(self):
        q = Q(id__in=(
            StaffCar.objects
            .filter(intranet_status=1)
            .values('staff_id')
        ))
        return q if self.cleaned_data['value'] else ~q
