from django.db.models import Q

from staff.person.models import Bicycle

from . import _forms
from ._base import lib, FieldFilter, BaseEqual


@lib.register
class HasBicycleFilter(FieldFilter):
    """Наличие велосипеда, [равно], да/нет"""


@HasBicycleFilter.register
class Equal(BaseEqual):
    form_cls = _forms.TrueBooleanForm
    hidden = True

    def q(self):
        q = Q(id__in=(Bicycle.objects.values('owner_id')))
        return q if self.cleaned_data['value'] else ~q
