from django.db.models import Q

from . import _forms
from ._base import lib, FieldFilter, BaseEqual


@lib.register
class BicycleFilter(FieldFilter):
    """Номер велосипеда, равно, инпут"""


@BicycleFilter.register
class Equal(BaseEqual):
    form_cls = _forms.IntForm

    def q(self):
        return Q(bicycles__plate=self.cleaned_data['value'])
