from django.db.models import Q

from staff.person.models import GENDER

import sform

from ._base import lib, FieldFilter, BaseEqual


male = GENDER.get_name(GENDER.MALE).lower()
female = GENDER.get_name(GENDER.FEMALE).lower()

GENDERS = [
    [male] * 2,
    [female] * 2,
]


@lib.register
class GenderFilter(FieldFilter):
    """Пол, равно, селект"""


class EqualForm(sform.SForm):
    gender = sform.ChoiceField(
        choices=GENDERS,
        state=sform.REQUIRED,
        default=male,
    )


@GenderFilter.register
class Equal(BaseEqual):
    form_cls = EqualForm

    def q(self):
        return Q(gender=getattr(GENDER, self.cleaned_data['gender'].upper()))
