from django.db.models import Q

from staff.person.models import FAMILY_STATUS

from . import _forms
from ._base import lib, FieldFilter, BaseEqual


@lib.register
class FamilyStatusFilter(FieldFilter):
    """Состоит в браке, [равно], да/нет"""


@FamilyStatusFilter.register
class Equal(BaseEqual):
    form_cls = _forms.TrueBooleanForm
    hidden = True

    def q(self):
        family_status = FAMILY_STATUS.SINGLE
        if self.cleaned_data['value']:
            family_status = FAMILY_STATUS.MARRIED
        return Q(family_status=family_status)
