from django.db.models import Q

from . import _forms
from ._base import lib, FieldFilter, BaseRange, BaseDayMonthYear, BaseEqual


@lib.register
class BirthdayFilter(FieldFilter):
    """День рождения, число-месяц-год/с-по/равно, 3 инпута/ ввод двух датв календарике / дата"""


@BirthdayFilter.register
class DayMonthYear(BaseDayMonthYear):
    form_cls = _forms.DayMonthYearForm

    def q(self):
        day = self.cleaned_data['day']
        month = self.cleaned_data['month']
        year = self.cleaned_data['year']

        q = Q()

        if day:
            q &= Q(birthday__day=day)
        if month:
            q &= Q(birthday__month=month)
        if year:
            q &= Q(birthday__year=year)

        return q


@BirthdayFilter.register
class Equal(BaseEqual):
    form_cls = _forms.DateForm

    def q(self):
        return Q(birthday=self.cleaned_data['date'])


@BirthdayFilter.register
class Range(BaseRange):
    form_cls = _forms.DateRangeForm

    def q(self):
        q = Q()
        if self.cleaned_data['start']:
            q &= Q(birthday__gte=self.cleaned_data['start'])

        if self.cleaned_data['end']:
            q &= Q(birthday__lte=self.cleaned_data['end'])

        return q
