import sform

from django.db.models import Q

from staff.person.models import TSHIRT_SIZE

from ._base import lib, FieldFilter, BaseEqual, BaseIn


@lib.register
class TshirtSizeFilter(FieldFilter):
    """Размер футболки, равно, селект"""


class EqualForm(sform.SForm):
    tshirt_size = sform.ChoiceField(
        choices=TSHIRT_SIZE,
        state=sform.REQUIRED,
    )


@TshirtSizeFilter.register
class Equal(BaseEqual):
    form_cls = EqualForm

    def q(self):
        return Q(tshirt_size=self.cleaned_data['tshirt_size'])


@TshirtSizeFilter.register
class Exclude(Equal):
    def q(self):
        return ~ super(Exclude, self).q()


class InForm(sform.SForm):
    tshirt_sizes = sform.MultipleChoiceField(
        choices=TSHIRT_SIZE,
        state=sform.REQUIRED,
    )


# @TshirtSizeFilter.register
class In(BaseIn):
    form_cls = InForm

    def q(self):
        return Q(tshirt_size__in=self.cleaned_data['tshirt_sizes'])
