from django.db.models import Q

from ._base import lib, FieldFilter, BaseContains
from . import _forms


@lib.register
class UniversityFilter(FieldFilter):
    """Сотрудники, в списке, саджест по сотрудникам"""


@UniversityFilter.register
class Contains(BaseContains):
    form_cls = _forms.CharForm

    def q(self):
        university_name = self.cleaned_data['value']
        return (Q(edu_place__icontains=university_name) |
                Q(edu_place_en__icontains=university_name))
