import sform

from django.db.models import Q

from staff.budget_position.models import BudgetPositionAssignment
from staff.departments.models import Department
from staff.proposal.forms.fields import ValueStreamField

from staff.person_filter.controller._base import lib, FieldFilter, BaseEqual, BaseIn, BaseInHierarchy


@lib.register
class ValueStreamFilter(FieldFilter):
    """VS"""


class EqualForm(sform.SForm):
    value_stream = ValueStreamField(
        queryset=Department.valuestreams.all(),
        label_fields='name',
        state=sform.REQUIRED,
    )


@ValueStreamFilter.register
class InHierarchy(BaseInHierarchy):
    form_cls = EqualForm

    def q(self):
        value_stream = self.cleaned_data['value_stream']

        return _construct_staff_selector(Q(
            value_stream__tree_id=value_stream.tree_id,
            value_stream__lft__gte=value_stream.lft,
            value_stream__rght__lte=value_stream.rght,
        ))


@ValueStreamFilter.register
class InHierarchyExclude(InHierarchy):
    def q(self):
        return ~ super(InHierarchyExclude, self).q()


@ValueStreamFilter.register
class Equal(BaseEqual):
    form_cls = EqualForm

    def q(self):
        return _construct_staff_selector(Q(value_stream=self.cleaned_data['value_stream']))


@ValueStreamFilter.register
class Exclude(Equal):
    def q(self):
        return ~ super(Exclude, self).q()


class MultipleSuggestField(sform.MultipleSuggestField):
    def structure_as_dict(self, *args, **kwargs):
        field_dict = super().structure_as_dict(*args, **kwargs)
        field_dict['types'] = ['value_stream']
        return field_dict


class InForm(sform.SForm):
    value_streams = MultipleSuggestField(
        queryset=Department.valuestreams.all(),
        label_fields='name',
        state=sform.REQUIRED,
    )


# @ValueStreamFilter.register
class In(BaseIn):
    form_cls = InForm

    def q(self):
        return _construct_staff_selector(Q(value_stream__in=self.cleaned_data['value_streams']))


def _construct_staff_selector(assignments_selector: Q) -> Q:
    assignments = BudgetPositionAssignment.objects.active().filter(assignments_selector).filter(main_assignment=True)

    return Q(assignments__in=assignments)
