import sform

from django.core.exceptions import ValidationError

from staff.person.models import Staff
from staff.departments.models import Department

from .controller import FilterCtl, FilterNotFound


class SavedFilterForm(sform.SForm):
    name = sform.CharField(state=sform.REQUIRED)

    is_bookmark = sform.BooleanField(default=False)
    is_for_cab = sform.BooleanField(default=True)

    absences_subscription = sform.BooleanField(default=False)
    # birthdays_subscription = sform.BooleanField(default=False)


class SavedFilterCreateForm(SavedFilterForm):
    department_url = sform.CharField()
    person_login = sform.CharField()
    filter_id = sform.CharField()

    def clean_filter_id(self, value):
        if value:
            try:
                FilterCtl.get_by_id(value)
            except FilterNotFound:
                raise ValidationError('invalid_choice', code='invalid_choice')
        else:
            value = None
        return value

    def clean_department_url(self, value):
        if value:
            try:
                dep = Department.objects.get(url=value)
            except Department.DoesNotExist:
                raise ValidationError('invalid_choice', code='invalid_choice')
            else:
                self.cleaned_data['department'] = dep
        else:
            self.cleaned_data['department'] = None
        return value

    def clean_person_login(self, value):
        if value:
            try:
                person = Staff.objects.get(login=value)
            except Staff.DoesNotExist:
                raise ValidationError('invalid_choice', code='invalid_choice')
            else:
                self.cleaned_data['person'] = person
        else:
            self.cleaned_data['person'] = None
        return value

    def clean(self):
        curent = (
            0 if self.cleaned_data.get('filter_id') is None else 1,
            0 if self.cleaned_data.get('person') is None else 1,
            0 if self.cleaned_data.get('department') is None else 1,
        )

        possible = {
            (1, 0, 0),
            (0, 1, 0),
            (0, 0, 1),
            (1, 0, 1),
        }

        if curent not in possible:
            raise ValidationError('invalid_combination', code='invalid_combination')

        return self.cleaned_data
